/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.datasource.GenericIterator;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.NavigationItem;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.extension.ExtensionRegistry;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.Font;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.SystrayService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Navigation
implements Part {
    private static final String KEY_NAVIGATION = "jameica.item.navigation";
    private Listener action = new MyActionListener();
    private DisposeListener dsl = new MyDisposeListener();
    private Listener start = new MyStartListener();
    private Settings settings = new Settings(Navigation.class);
    private Tree mainTree = null;
    private TreeItem pluginTree = null;
    private Map<String, TreeItem> itemLookup = new HashMap<String, TreeItem>();

    @Override
    public void paint(Composite parent) throws RemoteException {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        comp.setLayout((Layout)layout);
        this.mainTree = new Tree(comp, 0);
        this.mainTree.setLayoutData((Object)new GridData(1808));
        this.mainTree.addListener(17, this.action);
        this.mainTree.addListener(18, this.action);
        this.mainTree.addListener(4, this.action);
        this.mainTree.addListener(14, this.action);
        GUI.getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event e) {
                if (e.stateMask == 65536 && e.character == 'n') {
                    Navigation.this.mainTree.setFocus();
                }
            }
        });
        this.mainTree.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                GUI.getDisplay().removeFilter(2, Navigation.this.start);
            }

            public void focusGained(FocusEvent e) {
                GUI.getDisplay().addFilter(2, Navigation.this.start);
            }
        });
        if (!Customizing.SETTINGS.getBoolean("application.navigation.hideroot", false)) {
            try {
                this.load(Application.getManifest().getNavigation(), null);
            }
            catch (Exception e) {
                throw new RemoteException("error while loading navigation", e);
            }
        }
    }

    private void load(NavigationItem element, TreeItem parentTree) throws RemoteException {
        if (element == null) {
            return;
        }
        String name = element.getName();
        if (name == null) {
            this.loadChildren(element, parentTree);
            return;
        }
        TreeItem item = null;
        if (parentTree == null) {
            this.pluginTree = item = new TreeItem(this.mainTree, 0);
        } else {
            item = new TreeItem(parentTree, 0);
        }
        item.setFont(Font.DEFAULT.getSWTFont());
        item.addDisposeListener(this.dsl);
        item.setData(KEY_NAVIGATION, (Object)element);
        item.setText(name == null ? "" : name);
        this.expand(item);
        if (!element.isEnabled()) {
            item.setGrayed(true);
            item.setForeground(Color.COMMENT.getSWTColor());
        }
        this.itemLookup.put(element.getID(), item);
        ExtensionRegistry.extend(element);
        this.loadChildren(element, item);
    }

    protected void expand() {
        this.expand(null);
    }

    private void expand(TreeItem item) {
        if (this.mainTree == null) {
            return;
        }
        if (item != null) {
            try {
                NavigationItem ni = (NavigationItem)item.getData(KEY_NAVIGATION);
                boolean expanded = this.settings.getBoolean(ni.getID() + ".expanded", ni.isExpanded());
                item.setExpanded(expanded);
                item.setImage(expanded ? ni.getIconOpen() : ni.getIconClose());
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to expand item " + item.getText()), (Throwable)re);
            }
        }
        TreeItem[] childs = null;
        childs = item != null ? item.getItems() : this.mainTree.getItems();
        for (int i = 0; i < childs.length; ++i) {
            this.expand(childs[i]);
        }
    }

    private void loadChildren(NavigationItem element, TreeItem parentTree) throws RemoteException {
        GenericIterator childs = element.getChildren();
        if (childs == null || childs.size() == 0) {
            return;
        }
        while (childs.hasNext()) {
            this.load((NavigationItem)childs.next(), parentTree);
        }
    }

    protected void add(NavigationItem navi) throws Exception {
        if (navi == null) {
            return;
        }
        this.load(navi, this.pluginTree);
    }

    public void reload(NavigationItem item) throws Exception {
        if (item == null) {
            return;
        }
        TreeItem ti = this.itemLookup.get(item.getID());
        if (ti == null || ti.isDisposed()) {
            return;
        }
        for (TreeItem i : ti.getItems()) {
            i.dispose();
        }
        this.loadChildren(item, ti);
    }

    public void update(NavigationItem item) throws RemoteException {
        if (item == null) {
            return;
        }
        TreeItem ti = this.itemLookup.get(item.getID());
        if (ti == null || ti.isDisposed()) {
            return;
        }
        ti.setGrayed(!item.isEnabled());
        ti.setForeground(item.isEnabled() ? Color.FOREGROUND.getSWTColor() : Color.COMMENT.getSWTColor());
        ti.setText(item.getName());
        ti.setData(KEY_NAVIGATION, (Object)item);
    }

    public void setUnreadCount(String id, int unread) {
        TreeItem ti = this.itemLookup.get(id);
        if (ti == null || ti.isDisposed()) {
            return;
        }
        String title = (String)ti.getData("jameica.item.title");
        String current = ti.getText();
        if (title == null) {
            ti.setData("jameica.item.title", (Object)current);
            title = current;
        }
        ti.setData("unread", (Object)(unread > 0 ? Boolean.TRUE : null));
        if (unread > 0) {
            ti.setFont(Font.BOLD.getSWTFont());
            ti.setText(title + " (" + Integer.toString(unread) + ")");
        } else {
            ti.setFont(Font.DEFAULT.getSWTFont());
            ti.setText(title);
        }
        SystrayService systray = (SystrayService)Application.getBootLoader().getBootable(SystrayService.class);
        if (!systray.isEnabled()) {
            return;
        }
        boolean found = false;
        for (TreeItem i : this.itemLookup.values()) {
            if (i.getData("unread") == null) continue;
            found = true;
            break;
        }
        systray.setNewActivity(found);
    }

    public void select(String id) {
        if (id == null) {
            return;
        }
        TreeItem ti = this.itemLookup.get(id);
        if (ti == null) {
            return;
        }
        Event event = new Event();
        event.item = ti;
        event.type = 14;
        this.mainTree.notifyListeners(14, event);
    }

    private void start(NavigationItem item, Event event) {
        try {
            if (item == null || !item.isEnabled()) {
                return;
            }
            Action action = item.getAction();
            if (action == null) {
                return;
            }
            Logger.debug((String)("executing navigation entry " + item.getID() + " [" + item.getName() + "]"));
            if (event != null) {
                event.doit = false;
            }
            action.handleAction(event);
        }
        catch (ApplicationException e) {
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(e.getLocalizedMessage(), 1));
        }
        catch (RemoteException re) {
            Logger.error((String)"unable to handle navigation action", (Throwable)re);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Ausf\u00fchren des Menu-Eintrages"), 1));
        }
    }

    private class MyActionListener
    implements Listener {
        private MyActionListener() {
        }

        public void handleEvent(Event event) {
            Widget widget = event.item;
            if (widget == null) {
                widget = Navigation.this.mainTree.getItem(new Point(event.x, event.y));
            }
            if (widget == null || !(widget instanceof TreeItem) || widget.isDisposed()) {
                return;
            }
            TreeItem item = (TreeItem)widget;
            NavigationItem ni = (NavigationItem)item.getData(Navigation.KEY_NAVIGATION);
            if (ni == null) {
                return;
            }
            try {
                Action action = ni.getAction();
                boolean isFolder = ni.getChildren().size() > 0 && action == null;
                boolean execute = false;
                switch (event.type) {
                    case 17: {
                        Image icon = ni.getIconOpen();
                        if (icon == null) break;
                        item.setImage(icon);
                        break;
                    }
                    case 18: {
                        Image icon = ni.getIconClose();
                        if (icon == null) break;
                        item.setImage(icon);
                        break;
                    }
                    case 4: {
                        execute = action != null;
                        break;
                    }
                    case 14: {
                        boolean bl = execute = action != null;
                        if (!isFolder) break;
                        boolean expanded = item.getExpanded();
                        int type = expanded ? 18 : 17;
                        item.setExpanded(!expanded);
                        Event e = new Event();
                        e.item = item;
                        e.type = type;
                        Navigation.this.mainTree.notifyListeners(type, event);
                    }
                }
                if (execute) {
                    Navigation.this.start(ni, event);
                }
            }
            catch (RemoteException re) {
                Logger.error((String)"unable to handle navigation action", (Throwable)re);
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Ausf\u00fchren des Menu-Eintrages"), 1));
            }
        }
    }

    private class MyDisposeListener
    implements DisposeListener {
        private MyDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            try {
                if (e == null || e.widget == null || e.widget.isDisposed() || !(e.widget instanceof TreeItem)) {
                    return;
                }
                TreeItem item = (TreeItem)e.widget;
                NavigationItem data = (NavigationItem)e.widget.getData(Navigation.KEY_NAVIGATION);
                if (data == null) {
                    return;
                }
                Navigation.this.settings.setAttribute(data.getID() + ".expanded", item.getExpanded());
            }
            catch (Exception e2) {
                Logger.error((String)"unable to store expanded state", (Throwable)e2);
            }
        }
    }

    private class MyStartListener
    implements Listener {
        private MyStartListener() {
        }

        public void handleEvent(Event e) {
            if (e.stateMask == 0 && e.character == ' ') {
                TreeItem[] items = Navigation.this.mainTree.getSelection();
                if (items == null || items.length != 1) {
                    return;
                }
                Navigation.this.start((NavigationItem)items[0].getData(Navigation.KEY_NAVIGATION), e);
            }
        }
    }
}

